--Query to list all images currently used in cards
Select CC.Tag as [Image Name], C.Cardname as [Card Name], SF.SysFileID,
'\0\images\' + sys.fn_varbintohexsubstring(0, Convert(binary(4), SysFileID),1,0) as "Archive Path" 
From CardControls CC
Join Cards C on C.CardID = CC.CardID
Join SystemFiles SF on SF.FileName = cast(CC.Tag as nvarchar(260))
Where CC.Type = 1
Order by cast(CC.Tag as nvarchar(260))

--Query to list images from system files that are not used in any cards
SELECT DISTINCT FileName as "Image Name", 
SysFileID,
'\0\images\' + sys.fn_varbintohexsubstring(0, Convert(binary(4), SysFileID),1,0) as "Archive Path",
'Image is not used in any card' as [Status]
FROM SystemFiles
WHERE FileType = 0
and FileName not in (
	SELECT (cast(Tag as nvarchar(260)) )
	FROM CardControls
	WHERE Type = 1)
and FileName not like '__%__user_%'  --Exclude images used in profile cards
ORDER BY FileName

